<?php

namespace App\Models\Order;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Log extends Model 
{

    protected $table = 'order_logs';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('priority');
    protected $visible = array('priority');

    public function order()
    {
        return $this->belongsTo('App\Models\Order');
    }

}